﻿var recordedSessions = {
    context: $(".v-recordedSessions"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-recordedSessionsTable", this.context).a4datatable({            
            ajaxAction: a4.getAction("GetRecordedSessions", "Monitoring", "Project"),
            advancedFilter: true,
            columns: [                
                { "Data": "ProjectId", "Title": resources.Project },
                { "Data": "InterviewerName", "Title": resources.Interviewer },
                { "Data": "SupervisorName", "Title": resources.Supervisor },
                { "Data": "StartDateTime", "Title": resources.StartDate, "Type": "datetime" },
                { "Data": "EndDateTime", "Title": resources.EndDate, "Type": "datetime" },
                { "Data": "HasCommentLabel", "Name": "HasComment", "Title": resources.Comments, "Type": "boolean", "ShowIcon": true },
                { "Data": "GoalsCompletedLabel", "Name": "Status", "Title": resources.GoalsCompleted, "Type": "boolean", "ShowIcon": true },
            ],
            contextMenuItems: [
                { "Action": "details", "Label": resources.Details }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                switch (action) {
                    case "details":
                        recordedSessions.viewDetails(row);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchSessions }
        });
    },
    viewDetails: function (row) {
        modalDialog.showWindow(a4.getAction("SessionDetail", "Monitoring", "Project", { sessionId: row.Id }), 660, 950);
    }
}

$(document).ready(function () {
    if (recordedSessions.context.length > 0) {
        recordedSessions.initializeDataTable();
    }
});